/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Scrollbar;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class ThickLens
extends Applet {
    private double m_r1 = 400.0;
    private double m_r2 = 300.0;
    private double m_n = 1.5;
    private int m_x0 = 50;
    private int m_y0 = 150;
    private int m_yl = 100;
    private final double m_pi = 3.1416;
    private double m_thick1;
    private double m_center2;
    private final String PARAM_r1 = "r1";
    private final String PARAM_r2 = "r2";
    private final String PARAM_n = "n";
    Scrollbar verticalScrollbarR1 = new Scrollbar(1, 180, 1, 180, 699);
    Scrollbar verticalScrollbarR2 = new Scrollbar(1, 180, 1, 180, 699);
    Scrollbar verticalScrollbarN = new Scrollbar(1, 100, 1, 100, 169);
    TextField textFieldN = new TextField();
    Label label1 = new Label();
    Label label2 = new Label();
    Label label3 = new Label();
    Label label4 = new Label();

    public String getAppletInfo() {
        return "\u540d\u524d: ThickLens\r\n\u8457\u4f5c\u8005: \u795e\u5ddd \u5b9a\u4e45\r\nVisual Cafe \u3067\u4f5c\u6210\u3055\u308c\u307e\u3057\u305f";
    }

    public String[][] getParameterInfo() {
        String[][] info = new String[][]{{"r1", "double", "\u66f2\u7387\u534a\u5f84\uff11"}, {"r2", "double", "\u66f2\u7387\u534a\u5f84\uff12"}, {"n", "double", "\u5c48\u6298\u7387"}};
        return info;
    }

    public void init() {
        String param = this.getParameter("r1");
        if (param != null) {
            this.m_r1 = Double.valueOf(param);
        }
        if ((param = this.getParameter("r2")) != null) {
            this.m_r2 = Double.valueOf(param);
        }
        if ((param = this.getParameter("n")) != null) {
            this.m_n = Double.valueOf(param);
        }
        this.setLayout(null);
        this.setBackground(Color.white);
        this.setSize(600, 300);
        this.add(this.verticalScrollbarR1);
        this.verticalScrollbarR1.setBounds(480, 50, 24, 200);
        this.add(this.verticalScrollbarR2);
        this.verticalScrollbarR2.setBounds(516, 50, 25, 200);
        this.add(this.verticalScrollbarN);
        this.verticalScrollbarN.setBounds(552, 50, 25, 200);
        this.add(this.textFieldN);
        this.textFieldN.setBounds(548, 20, 30, 16);
        this.label1.setText("r1");
        this.label1.setAlignment(1);
        this.add(this.label1);
        this.label1.setBackground(Color.white);
        this.label1.setBounds(480, 264, 24, 24);
        this.label2.setText("r2");
        this.label2.setAlignment(1);
        this.add(this.label2);
        this.label2.setBackground(Color.white);
        this.label2.setBounds(516, 264, 26, 22);
        this.label3.setText("n");
        this.label3.setAlignment(1);
        this.add(this.label3);
        this.label3.setBackground(Color.white);
        this.label3.setBounds(552, 264, 24, 20);
        this.label4.setText("n");
        this.label4.setAlignment(2);
        this.add(this.label4);
        this.label4.setBackground(Color.white);
        this.label4.setBounds(528, 15, 14, 25);
        SymAdjustment lSymAdjustment = new SymAdjustment();
        this.verticalScrollbarR1.addAdjustmentListener(lSymAdjustment);
        this.verticalScrollbarR2.addAdjustmentListener(lSymAdjustment);
        this.verticalScrollbarN.addAdjustmentListener(lSymAdjustment);
        ((TextComponent)this.textFieldN).setText(Double.toString(this.m_n));
        this.verticalScrollbarR1.setValues(880 - (int)this.m_r1, 1, 180, 699);
        this.verticalScrollbarR2.setValues(880 - (int)this.m_r2, 1, 180, 699);
        this.verticalScrollbarN.setValues(270 - (int)(this.m_n * 100.0), 1, 100, 169);
    }

    public void paint(Graphics g) {
        int m_theta1 = (int)(57.29564553093965 * Math.asin((double)this.m_yl / this.m_r1)) + 1;
        int m_theta2 = (int)(57.29564553093965 * Math.asin((double)this.m_yl / this.m_r2)) + 1;
        this.m_thick1 = this.m_r1 - Math.sqrt(this.m_r1 * this.m_r1 - (double)(this.m_yl * this.m_yl));
        this.m_center2 = (double)this.m_x0 - Math.sqrt(this.m_r2 * this.m_r2 - (double)(this.m_yl * this.m_yl));
        g.setColor(Color.cyan);
        int m_yLens = this.m_yl;
        while (m_yLens > -this.m_yl) {
            int m_xLens1 = (int)((double)this.m_x0 - this.m_thick1 + this.m_r1 - Math.sqrt(this.m_r1 * this.m_r1 - (double)(m_yLens * m_yLens)));
            int m_xLens2 = (int)(this.m_center2 + Math.sqrt(this.m_r2 * this.m_r2 - (double)(m_yLens * m_yLens)));
            g.drawLine(m_xLens1, this.m_y0 - m_yLens, m_xLens2, this.m_y0 - m_yLens);
            --m_yLens;
        }
        g.setColor(Color.black);
        g.drawArc((int)((double)this.m_x0 - this.m_thick1), (int)((double)this.m_y0 - this.m_r1), (int)(2.0 * this.m_r1), (int)(2.0 * this.m_r1), 180 - m_theta1, m_theta1 * 2);
        g.drawArc((int)(this.m_center2 - this.m_r2), (int)((double)this.m_y0 - this.m_r2), (int)(2.0 * this.m_r2), (int)(2.0 * this.m_r2), -m_theta2, m_theta2 * 2);
        int m_yLight = 80;
        while (m_yLight >= -80) {
            this.drawLight(g, m_yLight);
            m_yLight -= 20;
        }
    }

    private void drawLight(Graphics g, int m_yLight1) {
        g.setColor(Color.blue);
        int m_xLight1 = (int)((double)this.m_x0 - this.m_thick1 + this.m_r1 - Math.sqrt(this.m_r1 * this.m_r1 - (double)(m_yLight1 * m_yLight1)));
        g.drawLine(0, this.m_y0 - m_yLight1, m_xLight1, this.m_y0 - m_yLight1);
        double m_xLight2 = m_xLight1;
        double m_yLight2 = m_yLight1;
        double m_w = m_yLight2 / this.m_r1;
        double m_angleI1 = Math.atan(m_w / Math.sqrt(1.0 - m_w * m_w));
        double m_angleR1 = Math.atan(m_w / this.m_n / Math.sqrt(1.0 - m_w / this.m_n * (m_w / this.m_n)));
        double m_ds = 0.2;
        double m_dx = m_ds * Math.cos(m_angleI1 - m_angleR1);
        double m_dy = -m_ds * Math.sin(m_angleI1 - m_angleR1);
        while ((m_xLight2 - this.m_center2) * (m_xLight2 - this.m_center2) + m_yLight2 * m_yLight2 < this.m_r2 * this.m_r2) {
            m_xLight2 += m_dx;
            m_yLight2 += m_dy;
        }
        g.drawLine(m_xLight1, this.m_y0 - m_yLight1, (int)m_xLight2, this.m_y0 - (int)m_yLight2);
        double m_angleTH = Math.atan(m_yLight2 / this.m_r2 / Math.sqrt(1.0 - m_yLight2 / this.m_r2 * (m_yLight2 / this.m_r2)));
        double m_angleI2 = m_angleTH + m_angleI1 - m_angleR1;
        double m_u = this.m_n * Math.sin(m_angleI2);
        double m_angleR2 = Math.atan(m_u / Math.sqrt(1.0 - m_u * m_u));
        g.drawLine((int)m_xLight2, (int)((double)this.m_y0 - m_yLight2), 500, (int)((double)this.m_y0 - m_yLight2 + (600.0 - m_xLight2) * Math.tan(m_angleR2 - m_angleTH)));
        g.setColor(Color.black);
    }

    void verticalScrollbarR1_AdjustmentValueChanged(AdjustmentEvent event) {
        this.m_r1 = 880 - event.getValue();
        this.repaint();
    }

    void verticalScrollbarR2_AdjustmentValueChanged(AdjustmentEvent event) {
        this.m_r2 = 880 - event.getValue();
        this.repaint();
    }

    void verticalScrollbarN_AdjustmentValueChanged(AdjustmentEvent event) {
        this.m_n = (double)(270 - event.getValue()) / 100.0;
        ((TextComponent)this.textFieldN).setText(Double.toString(this.m_n));
        this.repaint();
    }

    class SymAdjustment
    implements AdjustmentListener {
        public void adjustmentValueChanged(AdjustmentEvent event) {
            Object object = event.getSource();
            if (object == ThickLens.this.verticalScrollbarR1) {
                ThickLens.this.verticalScrollbarR1_AdjustmentValueChanged(event);
            } else if (object == ThickLens.this.verticalScrollbarR2) {
                ThickLens.this.verticalScrollbarR2_AdjustmentValueChanged(event);
            } else if (object == ThickLens.this.verticalScrollbarN) {
                ThickLens.this.verticalScrollbarN_AdjustmentValueChanged(event);
            }
        }

        SymAdjustment() {
            ThickLens.this = ThickLens.this;
        }
    }
}

