/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class LongTrans
extends Applet
implements Runnable {
    Thread m_LongTrans;
    int loopslot;
    int pause;
    boolean threadSuspended = false;
    Image im;
    int center;
    int nphase = 13;
    int nthings = 16;
    int cyanBall = 4;
    int time;
    int offset;
    int ref;
    char type = (char)84;
    char currentType = (char)84;
    Graphics offscreen;
    int[] SinTable = new int[100];
    int[] Wave;
    int[] iWave;
    Button button_play = new Button();
    Button button_back = new Button();
    Button button_forward = new Button();
    Button button_stop = new Button();
    Button button_Reset = new Button();
    Checkbox radioButton_trans = new Checkbox();
    CheckboxGroup Group1 = new CheckboxGroup();
    Checkbox radioButton_long = new Checkbox();

    public String getAppletInfo() {
        return "Name: LongTrans\r\nAuthor: Sadahisa Kamikawa\r\nCreated with Visual Cafe";
    }

    public void init() {
        this.center = this.getSize().height / 2;
        double dx = Math.PI * 2 / (double)(this.nphase - 1);
        this.Wave = new int[this.nphase];
        this.iWave = new int[this.nthings];
        String at = this.getParameter("pause");
        this.pause = at == null ? 100 : Integer.valueOf(at);
        int i = 0;
        while (i < this.nphase) {
            this.SinTable[i] = (int)(30.0 * Math.sin(dx * (double)i));
            ++i;
        }
        int i2 = 0;
        while (i2 < this.nphase) {
            this.Wave[i2] = -this.SinTable[i2];
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.nthings) {
            this.iWave[i3] = 0;
            ++i3;
        }
        this.setLayout(null);
        this.setBackground(Color.white);
        this.setSize(600, 120);
        this.button_play.setLabel("Play");
        this.add(this.button_play);
        this.button_play.setBackground(Color.lightGray);
        this.button_play.setBounds(500, 8, 80, 20);
        this.button_back.setLabel("<<");
        this.add(this.button_back);
        this.button_back.setBackground(Color.lightGray);
        this.button_back.setBounds(500, 28, 20, 20);
        this.button_forward.setLabel(">>");
        this.add(this.button_forward);
        this.button_forward.setBackground(Color.lightGray);
        this.button_forward.setBounds(560, 28, 20, 20);
        this.button_stop.setLabel("Stop");
        this.add(this.button_stop);
        this.button_stop.setBackground(Color.lightGray);
        this.button_stop.setBounds(520, 28, 40, 20);
        this.button_Reset.setLabel("Reset");
        this.add(this.button_Reset);
        this.button_Reset.setBackground(Color.lightGray);
        this.button_Reset.setBounds(500, 48, 80, 20);
        this.radioButton_trans.setCheckboxGroup(this.Group1);
        this.radioButton_trans.setState(true);
        this.radioButton_trans.setLabel("Transverse");
        this.add(this.radioButton_trans);
        this.radioButton_trans.setFont(new Font("Dialog", 0, 11));
        this.radioButton_trans.setBounds(500, 80, 82, 12);
        this.radioButton_long.setCheckboxGroup(this.Group1);
        this.radioButton_long.setLabel("Longitudinal");
        this.add(this.radioButton_long);
        this.radioButton_long.setFont(new Font("Dialog", 0, 11));
        this.radioButton_long.setBounds(500, 96, 82, 12);
        SymAction lSymAction = new SymAction();
        this.button_play.addActionListener(lSymAction);
        this.button_back.addActionListener(lSymAction);
        this.button_forward.addActionListener(lSymAction);
        this.button_stop.addActionListener(lSymAction);
        this.button_Reset.addActionListener(lSymAction);
        SymItem lSymItem = new SymItem();
        this.radioButton_trans.addItemListener(lSymItem);
        this.radioButton_long.addItemListener(lSymItem);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        if (this.im == null) {
            this.im = this.createImage(d.width, d.height);
            this.offscreen = this.im.getGraphics();
        }
        this.offscreen.setColor(Color.white);
        this.offscreen.fillRect(0, 0, d.width, d.height);
        this.offscreen.setColor(Color.green);
        this.offscreen.drawLine(0, this.center - 30, 30 * (this.nthings - 1), this.center - 30);
        this.offscreen.drawLine(0, this.center + 30, 30 * (this.nthings - 1), this.center + 30);
        int i = 0;
        while (i < this.nthings) {
            this.offscreen.drawLine(30 * i, this.center - 30, 30 * i, this.center + 30);
            this.offset = (this.nphase - 1 + i - this.loopslot) % (this.nphase - 1);
            if (this.time > i) {
                this.iWave[i] = this.Wave[this.offset];
            }
            ++i;
        }
        this.offscreen.setColor(Color.cyan);
        this.offscreen.drawLine(0, this.center, 30 * (this.nthings - 1), this.center);
        switch (this.type) {
            case 'T': {
                int i2 = 0;
                while (i2 < this.nthings) {
                    this.offscreen.setColor(Color.red);
                    this.offscreen.drawLine(30 * i2, this.center - this.iWave[i2], 30 * i2, this.center);
                    if (this.currentType == 'L') {
                        this.offscreen.setColor(Color.black);
                        if (this.iWave[i2] > 0) {
                            this.offscreen.drawArc(30 * i2 - this.iWave[i2], this.center - this.iWave[i2], this.iWave[i2] * 2, this.iWave[i2] * 2, 0, 90);
                        } else {
                            this.offscreen.drawArc(30 * i2 + this.iWave[i2], this.center + this.iWave[i2], -this.iWave[i2] * 2, -this.iWave[i2] * 2, 180, 90);
                        }
                    }
                    this.offscreen.setColor(Color.blue);
                    if (i2 == this.cyanBall) {
                        this.offscreen.setColor(Color.cyan);
                    }
                    this.offscreen.fillOval(30 * i2 - 15, this.center - 3 - this.iWave[i2], 30, 6);
                    ++i2;
                }
                this.currentType = (char)84;
                break;
            }
            case 'L': {
                int i3 = 0;
                while (i3 < this.nthings) {
                    this.offscreen.setColor(Color.red);
                    this.offscreen.drawLine(30 * i3 + this.iWave[i3], this.center, 30 * i3, this.center);
                    if (this.currentType == 'T') {
                        this.offscreen.setColor(Color.black);
                        if (this.iWave[i3] > 0) {
                            this.offscreen.drawArc(30 * i3 - this.iWave[i3], this.center - this.iWave[i3], this.iWave[i3] * 2, this.iWave[i3] * 2, 0, 90);
                        } else {
                            this.offscreen.drawArc(30 * i3 + this.iWave[i3], this.center + this.iWave[i3], -this.iWave[i3] * 2, -this.iWave[i3] * 2, 180, 90);
                        }
                    }
                    this.offscreen.setColor(Color.blue);
                    if (i3 == this.cyanBall) {
                        this.offscreen.setColor(Color.cyan);
                    }
                    this.offscreen.fillOval(30 * i3 - 3 + this.iWave[i3], this.center - 15, 6, 30);
                    ++i3;
                }
                this.currentType = (char)76;
                break;
            }
        }
        g.drawImage(this.im, 0, 0, this);
    }

    public void start() {
    }

    public void stop() {
        if (this.m_LongTrans != null) {
            this.m_LongTrans.stop();
            this.m_LongTrans = null;
        }
    }

    public void run() {
        if (this.nphase > 1) {
            while (this.getSize().width > 0 && this.getSize().height > 0 && this.m_LongTrans != null) {
                if (++this.loopslot >= this.nphase - 1) {
                    this.loopslot = 0;
                }
                ++this.time;
                this.repaint();
                try {
                    Thread.sleep(this.pause);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }

    public void startMotion() {
        if (this.m_LongTrans == null) {
            this.m_LongTrans = new Thread(this);
            this.m_LongTrans.start();
            this.threadSuspended = false;
        } else if (this.threadSuspended) {
            this.m_LongTrans.resume();
            this.threadSuspended = false;
        } else {
            this.m_LongTrans.suspend();
            this.threadSuspended = true;
            this.time = 0;
            this.loopslot = 0;
            int i = 0;
            while (i < this.nthings) {
                this.iWave[i] = 0;
                ++i;
            }
            this.repaint();
            this.m_LongTrans.resume();
            this.threadSuspended = false;
        }
    }

    public void stopMotion() {
        if (this.m_LongTrans != null && !this.threadSuspended) {
            this.m_LongTrans = null;
            this.threadSuspended = true;
        }
    }

    public void Forward() {
        if (++this.loopslot >= this.nphase - 1) {
            this.loopslot = 0;
        }
        if (++this.time > this.nthings) {
            this.time = this.nthings * 2;
        }
        this.repaint();
    }

    public void Back() {
        int i = 0;
        while (i < this.nthings) {
            this.iWave[i] = 0;
            ++i;
        }
        if (--this.loopslot <= 0) {
            this.loopslot = this.nphase - 1;
        }
        if (--this.time < 0) {
            this.loopslot = 0;
            this.time = 0;
        }
        this.repaint();
    }

    public void resetWave() {
        if (this.m_LongTrans != null && !this.threadSuspended) {
            this.m_LongTrans = null;
            this.threadSuspended = true;
        }
        this.time = 0;
        this.loopslot = 0;
        int i = 0;
        while (i < this.nthings) {
            this.iWave[i] = 0;
            ++i;
        }
        this.repaint();
    }

    void buttonPlay_ActionPerformed(ActionEvent event) {
        this.startMotion();
    }

    void buttonBack_ActionPerformed(ActionEvent event) {
        this.Back();
    }

    void buttonForward_ActionPerformed(ActionEvent event) {
        this.Forward();
    }

    void buttonStop_ActionPerformed(ActionEvent event) {
        this.stopMotion();
    }

    void buttonReset_ActionPerformed(ActionEvent event) {
        this.resetWave();
    }

    void radioButtonTrans_ItemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.type = (char)84;
            this.repaint();
        }
    }

    void radioButtonLong_ItemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.type = (char)76;
            this.repaint();
        }
    }

    class SymAction
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == LongTrans.this.button_play) {
                LongTrans.this.buttonPlay_ActionPerformed(event);
            } else if (object == LongTrans.this.button_back) {
                LongTrans.this.buttonBack_ActionPerformed(event);
            } else if (object == LongTrans.this.button_forward) {
                LongTrans.this.buttonForward_ActionPerformed(event);
            } else if (object == LongTrans.this.button_stop) {
                LongTrans.this.buttonStop_ActionPerformed(event);
            } else if (object == LongTrans.this.button_Reset) {
                LongTrans.this.buttonReset_ActionPerformed(event);
            }
        }

        SymAction() {
            LongTrans.this = LongTrans.this;
        }
    }

    class SymItem
    implements ItemListener {
        public void itemStateChanged(ItemEvent event) {
            Object object = event.getSource();
            if (object == LongTrans.this.radioButton_trans) {
                LongTrans.this.radioButtonTrans_ItemStateChanged(event);
            } else if (object == LongTrans.this.radioButton_long) {
                LongTrans.this.radioButtonLong_ItemStateChanged(event);
            }
        }

        SymItem() {
            LongTrans.this = LongTrans.this;
        }
    }
}

