/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class ConvexMirror
extends Applet {
    Color c1 = new Color(240, 240, 255);
    int x0;
    int y0;
    int x1;
    int y1;
    int tall;
    int focus;
    int radius;
    int center;
    int m_theta;
    int xmirror;
    int xthing;
    double m_cos;
    double m_sin;
    private final double m_pi = 3.1416;
    String s0 = "";
    Image m_OffScreen;
    Graphics m_OffGraphics;

    public void init() {
        this.setLayout(null);
        this.setSize(580, 180);
        Dimension d = this.getSize();
        this.x0 = d.width / 2;
        this.y0 = d.height / 2;
        this.tall = this.y0 / 4;
        this.focus = this.x0 / 3;
        this.radius = this.focus * 2;
        this.center = this.x0 + this.radius;
        this.m_theta = (int)(57.29564553093965 * Math.asin((double)this.y0 / (double)this.radius));
        this.xmirror = this.center - (int)Math.sqrt(this.radius * this.radius - this.tall * this.tall);
        this.xthing = this.x0 / 8;
        this.m_OffScreen = this.createImage(d.width, d.height);
        this.m_OffGraphics = this.m_OffScreen.getGraphics();
        SymMouseMotion aSymMouseMotion = new SymMouseMotion();
        this.addMouseMotionListener(aSymMouseMotion);
        SymMouse aSymMouse = new SymMouse();
        this.addMouseListener(aSymMouse);
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        this.m_OffGraphics.setColor(this.c1);
        this.m_OffGraphics.fillRect(0, 0, d.width, d.height);
        this.m_OffGraphics.setColor(Color.gray);
        this.m_OffGraphics.drawArc(this.center - this.radius, this.y0 - this.radius, 2 * this.radius, 2 * this.radius, 180 - this.m_theta, this.m_theta * 2);
        this.m_OffGraphics.setColor(Color.black);
        this.m_OffGraphics.drawLine(0, this.y0, d.width, this.y0);
        this.m_OffGraphics.drawLine(this.x0, 0, this.x0, d.height);
        this.m_OffGraphics.drawLine(this.x0 + this.focus, this.y0 - 5, this.x0 + this.focus, this.y0 + 5);
        this.m_OffGraphics.drawLine(this.center, this.y0 - 5, this.center, this.y0 + 5);
        this.m_OffGraphics.setColor(Color.red);
        this.m_OffGraphics.drawLine(this.xthing, this.y0 - this.tall, this.xthing, this.y0);
        this.m_OffGraphics.drawLine(this.xthing, this.y0 - this.tall, this.xthing - 3, this.y0 - this.tall + 5);
        this.m_OffGraphics.drawLine(this.xthing, this.y0 - this.tall, this.xthing + 3, this.y0 - this.tall + 5);
        this.m_OffGraphics.setColor(Color.green);
        this.m_OffGraphics.drawLine(this.xthing, this.y0 - this.tall, this.xmirror, this.y0 - this.tall);
        this.m_OffGraphics.drawLine(this.xmirror, this.y0 - this.tall, this.x0 + this.focus - (this.focus - this.xmirror + this.x0) * this.y0 / this.tall, 0);
        this.m_cos = (double)(this.center - this.xthing) / Math.sqrt((this.center - this.xthing) * (this.center - this.xthing) + this.tall * this.tall);
        this.m_sin = (double)this.tall / Math.sqrt((this.center - this.xthing) * (this.center - this.xthing) + this.tall * this.tall);
        this.m_OffGraphics.drawLine(this.xthing, this.y0 - this.tall, this.center - (int)((double)this.radius * this.m_cos), this.y0 - (int)((double)this.radius * this.m_sin));
        this.m_OffGraphics.setColor(Color.yellow);
        this.m_OffGraphics.drawLine(this.xmirror, this.y0 - this.tall, this.x0 * 2, this.y0 + this.tall * (this.x0 - this.focus) / (this.focus - this.xmirror + this.x0));
        this.m_OffGraphics.drawLine(this.center - (int)((double)this.radius * this.m_cos), this.y0 - (int)((double)this.radius * this.m_sin), this.x0 * 2, this.y0 + (int)((double)(this.x0 * 2 - this.center) * this.m_sin / this.m_cos));
        if (this.x0 - this.xthing != this.focus) {
            float b = -((float)this.focus) * (float)(this.x0 - this.xthing) / (float)(this.x0 - this.xthing + this.focus);
            if (b < 0.0f) {
                this.m_OffGraphics.setColor(Color.magenta);
            } else {
                this.m_OffGraphics.setColor(Color.blue);
            }
            this.m_OffGraphics.drawLine(this.x0 - (int)b, this.y0, this.x0 - (int)b, this.y0 + (int)(b * (float)this.tall / (float)(this.x0 - this.xthing)));
            this.m_OffGraphics.drawLine(this.x0 - (int)b, this.y0 + (int)(b * (float)this.tall / (float)(this.x0 - this.xthing)), this.x0 - (int)((double)b * (1.0 + 3.0 / (double)(this.x0 - this.xthing))), this.y0 + (int)(b * (float)(this.tall - 5) / (float)(this.x0 - this.xthing)));
            this.m_OffGraphics.drawLine(this.x0 - (int)b, this.y0 + (int)(b * (float)this.tall / (float)(this.x0 - this.xthing)), this.x0 - (int)((double)b * (1.0 - 3.0 / (double)(this.x0 - this.xthing))), this.y0 + (int)(b * (float)(this.tall - 5) / (float)(this.x0 - this.xthing)));
        }
        g.drawImage(this.m_OffScreen, 0, 0, null);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    void ConvexMirror_MouseDragged(MouseEvent event) {
        int x = event.getX();
        if (x >= this.x0 - 5) {
            x = this.x0 - 6;
        } else {
            this.xthing = x;
        }
        this.repaint(0L);
    }

    void ConvexMirror_mousePressed(MouseEvent event) {
        int x = event.getX();
        if (x >= this.x0) {
            x = this.x0 - 1;
        } else {
            this.xthing = x;
        }
        this.repaint(0L);
    }

    class SymMouseMotion
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent event) {
            Object object = event.getSource();
            if (object == ConvexMirror.this) {
                ConvexMirror.this.ConvexMirror_MouseDragged(event);
            }
        }

        SymMouseMotion() {
            ConvexMirror.this = ConvexMirror.this;
        }
    }

    class SymMouse
    extends MouseAdapter {
        public void mousePressed(MouseEvent event) {
            Object object = event.getSource();
            if (object == ConvexMirror.this) {
                ConvexMirror.this.ConvexMirror_mousePressed(event);
            }
        }

        SymMouse() {
            ConvexMirror.this = ConvexMirror.this;
        }
    }
}

