/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class CaiWave
extends Applet
implements Runnable {
    Thread m_CaiWave;
    int loopslot;
    int pause;
    boolean threadSuspended = false;
    Image im;
    int center;
    int m_Height;
    int nphase = 17;
    int nthings = 39;
    int cyanBall = 14;
    int time;
    int offset;
    int ref;
    char shape = (char)87;
    Graphics offscreen;
    int[] SinTable = new int[100];
    int[] Wave;
    int[] iWave;
    int[] rWave;
    int[] Things;
    Button button_Play = new Button();
    Button button_back = new Button();
    Button button_forward = new Button();
    Button button_stop = new Button();
    Button button_reset = new Button();
    Panel panel1 = new Panel();
    Checkbox radioButton_continuous = new Checkbox();
    CheckboxGroup Group1 = new CheckboxGroup();
    Checkbox radioButton_crest = new Checkbox();
    Checkbox radioButton_trough = new Checkbox();
    Panel panel2 = new Panel();
    Checkbox radioButton_free = new Checkbox();
    CheckboxGroup Group2 = new CheckboxGroup();
    Checkbox radioButton_fixed = new Checkbox();
    Checkbox radioButton_less = new Checkbox();

    public String getAppletInfo() {
        return "Name: CaiWave\r\nAuthor: Sadahisa Kamikawa\r\nCreated with Visual Cafe";
    }

    public void init() {
        this.center = this.getSize().height / 2;
        this.cyanBall = this.nthings - this.nphase - (this.nphase - 1) / 2;
        double dx = Math.PI * 2 / (double)(this.nphase - 1);
        this.Wave = new int[this.nphase];
        this.iWave = new int[this.nthings * 2];
        this.rWave = new int[this.nthings];
        this.Things = new int[this.nthings];
        String at = this.getParameter("pause");
        this.pause = at == null ? 100 : Integer.valueOf(at);
        int i = 0;
        while (i < this.nphase) {
            this.SinTable[i] = (int)((double)((this.center - 4) / 2) * Math.sin(dx * (double)i));
            ++i;
        }
        int i2 = 0;
        while (i2 < this.nphase) {
            this.Wave[i2] = -this.SinTable[i2];
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.nthings * 2) {
            this.iWave[i3] = 0;
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.nthings) {
            this.rWave[i4] = 0;
            this.Things[i4] = 0;
            ++i4;
        }
        this.setLayout(null);
        this.setBackground(Color.white);
        this.setSize(600, 200);
        this.button_Play.setLabel("Play");
        this.add(this.button_Play);
        this.button_Play.setBackground(Color.lightGray);
        this.button_Play.setBounds(408, 12, 140, 25);
        this.button_back.setLabel("<<  Back");
        this.add(this.button_back);
        this.button_back.setBackground(Color.lightGray);
        this.button_back.setBounds(408, 36, 70, 25);
        this.button_forward.setLabel("Forward >>");
        this.add(this.button_forward);
        this.button_forward.setBackground(Color.lightGray);
        this.button_forward.setBounds(478, 36, 70, 25);
        this.button_stop.setLabel("Stop");
        this.add(this.button_stop);
        this.button_stop.setBackground(Color.lightGray);
        this.button_stop.setBounds(408, 60, 140, 25);
        this.button_reset.setLabel("Reset");
        this.add(this.button_reset);
        this.button_reset.setBackground(Color.lightGray);
        this.button_reset.setBounds(408, 84, 140, 25);
        this.panel1.setLayout(null);
        this.add(this.panel1);
        this.panel1.setBackground(new Color(255, 255, 128));
        this.panel1.setBounds(408, 115, 96, 75);
        this.radioButton_continuous.setCheckboxGroup(this.Group1);
        this.radioButton_continuous.setState(true);
        this.radioButton_continuous.setLabel("Continuous");
        this.panel1.add(this.radioButton_continuous);
        this.radioButton_continuous.setBounds(0, 7, 96, 17);
        this.radioButton_crest.setCheckboxGroup(this.Group1);
        this.radioButton_crest.setLabel("Pulse Crest");
        this.panel1.add(this.radioButton_crest);
        this.radioButton_crest.setBounds(0, 31, 96, 12);
        this.radioButton_trough.setCheckboxGroup(this.Group1);
        this.radioButton_trough.setLabel("Pulse Trough");
        this.panel1.add(this.radioButton_trough);
        this.radioButton_trough.setBounds(0, 55, 96, 12);
        this.panel2.setLayout(null);
        this.add(this.panel2);
        this.panel2.setBackground(new Color(170, 255, 170));
        this.panel2.setBounds(506, 115, 84, 75);
        this.radioButton_free.setCheckboxGroup(this.Group2);
        this.radioButton_free.setLabel("Free End");
        this.panel2.add(this.radioButton_free);
        this.radioButton_free.setBounds(0, 7, 75, 12);
        this.radioButton_fixed.setCheckboxGroup(this.Group2);
        this.radioButton_fixed.setLabel("Fixed End");
        this.panel2.add(this.radioButton_fixed);
        this.radioButton_fixed.setBounds(0, 31, 75, 12);
        this.radioButton_less.setCheckboxGroup(this.Group2);
        this.radioButton_less.setState(true);
        this.radioButton_less.setLabel("End Less");
        this.panel2.add(this.radioButton_less);
        this.radioButton_less.setBounds(0, 55, 75, 12);
        SymAction lSymAction = new SymAction();
        this.button_Play.addActionListener(lSymAction);
        this.button_back.addActionListener(lSymAction);
        this.button_forward.addActionListener(lSymAction);
        this.button_stop.addActionListener(lSymAction);
        this.button_reset.addActionListener(lSymAction);
        SymItem lSymItem = new SymItem();
        this.radioButton_continuous.addItemListener(lSymItem);
        this.radioButton_crest.addItemListener(lSymItem);
        this.radioButton_trough.addItemListener(lSymItem);
        this.radioButton_free.addItemListener(lSymItem);
        this.radioButton_fixed.addItemListener(lSymItem);
        this.radioButton_less.addItemListener(lSymItem);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        int i;
        Dimension d = this.getSize();
        if (this.im == null) {
            this.im = this.createImage(d.width, d.height);
            this.offscreen = this.im.getGraphics();
            this.offscreen.setColor(Color.white);
        }
        this.offscreen.fillRect(0, 0, d.width, d.height);
        switch (this.shape) {
            case 'C': {
                i = 0;
                while (i < this.nthings * 2) {
                    this.offset = (this.nphase - 1 + i - this.loopslot) % (this.nphase - 1);
                    this.iWave[i] = this.time > i && this.time - (this.nphase + 1) / 2 < i ? this.Wave[this.offset] : 0;
                    if (i >= this.nthings - 1 && i <= this.nthings * 2 - 2) {
                        this.rWave[this.nthings * 2 - 2 - i] = this.ref * this.iWave[i];
                    }
                    ++i;
                }
                break;
            }
            case 'T': {
                i = 0;
                while (i < this.nthings * 2) {
                    this.offset = (this.nphase - 1 + i - this.loopslot + (this.nphase + 1) / 2) % (this.nphase - 1);
                    this.iWave[i] = this.time > i && this.time - (this.nphase + 1) / 2 < i ? this.Wave[this.offset] : 0;
                    if (i >= this.nthings - 1 && i <= this.nthings * 2 - 2) {
                        this.rWave[this.nthings * 2 - 2 - i] = this.ref * this.iWave[i];
                    }
                    ++i;
                }
                break;
            }
            default: {
                i = 0;
                while (i < this.nthings * 2) {
                    this.offset = (this.nphase - 1 + i - this.loopslot) % (this.nphase - 1);
                    if (this.time > i) {
                        this.iWave[i] = this.Wave[this.offset];
                    }
                    if (i >= this.nthings - 1 && i <= this.nthings * 2 - 2) {
                        this.rWave[this.nthings * 2 - 2 - i] = this.ref * this.iWave[i];
                    }
                    ++i;
                }
                break block0;
            }
        }
        i = 0;
        while (i < this.nthings) {
            this.Things[i] = this.iWave[i] + this.rWave[i];
            this.offscreen.setColor(Color.blue);
            if (i == this.cyanBall) {
                this.offscreen.setColor(Color.cyan);
            }
            this.offscreen.fillOval(10 * i - 4, this.center - 4 - this.Things[i], 8, 8);
            ++i;
        }
        int i2 = 1;
        while (i2 < this.nthings) {
            this.offscreen.setColor(Color.green);
            this.offscreen.drawLine(10 * (i2 - 1), this.center - this.rWave[i2 - 1], 10 * i2, this.center - this.rWave[i2]);
            this.offscreen.setColor(Color.red);
            this.offscreen.drawLine(10 * (i2 - 1), this.center - this.iWave[i2 - 1], 10 * i2, this.center - this.iWave[i2]);
            ++i2;
        }
        if (this.ref < 0) {
            this.offscreen.setColor(Color.black);
            this.offscreen.fillRect((this.nthings - 1) * 10 + 5, 0, 15, d.height);
        }
        if (this.ref > 0) {
            this.offscreen.setColor(Color.yellow);
            this.offscreen.drawLine((this.nthings - 1) * 10, 0, (this.nthings - 1) * 10, d.height);
        }
        this.offscreen.setColor(Color.white);
        if (this.ref == 0) {
            this.offscreen.fillRect((this.nthings - 1) * 10, 0, 10, d.height);
        }
        g.drawImage(this.im, 0, 0, this);
    }

    public void start() {
    }

    public void stop() {
        if (this.m_CaiWave != null) {
            this.m_CaiWave.stop();
            this.m_CaiWave = null;
        }
    }

    public void run() {
        if (this.nphase > 1) {
            while (this.getSize().width > 0 && this.getSize().height > 0 && this.m_CaiWave != null) {
                if (++this.loopslot >= this.nphase - 1) {
                    this.loopslot = 0;
                }
                ++this.time;
                this.repaint();
                try {
                    Thread.sleep(this.pause);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }

    public void startMotion() {
        if (this.m_CaiWave == null) {
            this.m_CaiWave = new Thread(this);
            this.m_CaiWave.start();
            this.threadSuspended = false;
        } else if (this.threadSuspended) {
            this.m_CaiWave.resume();
            this.threadSuspended = false;
        } else {
            this.m_CaiWave.suspend();
            this.threadSuspended = true;
            this.time = 0;
            this.loopslot = 0;
            int i = 0;
            while (i < this.nthings * 2) {
                this.iWave[i] = 0;
                ++i;
            }
            int i2 = 0;
            while (i2 < this.nthings) {
                this.rWave[i2] = 0;
                this.Things[i2] = 0;
                ++i2;
            }
            this.repaint();
            this.m_CaiWave.resume();
            this.threadSuspended = false;
        }
    }

    public void stopMotion() {
        if (this.m_CaiWave != null && !this.threadSuspended) {
            this.m_CaiWave = null;
            this.threadSuspended = true;
        }
    }

    public void Forward() {
        if (++this.loopslot >= this.nphase - 1) {
            this.loopslot = 0;
        }
        if (++this.time > this.nthings * 2) {
            this.time = this.nthings * 2;
        }
        this.repaint();
    }

    public void Back() {
        int i = 0;
        while (i < this.nthings * 2) {
            this.iWave[i] = 0;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.nthings) {
            this.rWave[i2] = 0;
            this.Things[i2] = 0;
            ++i2;
        }
        if (--this.loopslot <= 0) {
            this.loopslot = this.nphase - 1;
        }
        if (--this.time < 0) {
            this.loopslot = 0;
            this.time = 0;
        }
        this.repaint();
    }

    public void resetWave() {
        if (this.m_CaiWave != null && !this.threadSuspended) {
            this.m_CaiWave = null;
            this.threadSuspended = true;
        }
        this.time = 0;
        this.loopslot = 0;
        int i = 0;
        while (i < this.nthings * 2) {
            this.iWave[i] = 0;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.nthings) {
            this.rWave[i2] = 0;
            this.Things[i2] = 0;
            ++i2;
        }
        this.repaint();
    }

    void buttonPlay_ActionPerformed(ActionEvent event) {
        this.startMotion();
    }

    void buttonBack_ActionPerformed(ActionEvent event) {
        this.Back();
    }

    void buttonForward_ActionPerformed(ActionEvent event) {
        this.Forward();
    }

    void buttonStop_ActionPerformed(ActionEvent event) {
        this.stopMotion();
    }

    void buttonReset_ActionPerformed(ActionEvent event) {
        this.resetWave();
    }

    void radioButtonContinuous_ItemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.shape = (char)87;
            this.resetWave();
        }
    }

    void radioButtonCrest_ItemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.shape = (char)67;
            this.resetWave();
        }
    }

    void radioButtonTrough_ItemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.shape = (char)84;
            this.resetWave();
        }
    }

    void radioButtonFree_ItemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.ref = 1;
            this.repaint();
        }
    }

    void radioButtonFixed_ItemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.ref = -1;
            this.repaint();
        }
    }

    void radioButtonLess_ItemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.ref = 0;
            this.repaint();
        }
    }

    class SymAction
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == CaiWave.this.button_Play) {
                CaiWave.this.buttonPlay_ActionPerformed(event);
            } else if (object == CaiWave.this.button_back) {
                CaiWave.this.buttonBack_ActionPerformed(event);
            } else if (object == CaiWave.this.button_forward) {
                CaiWave.this.buttonForward_ActionPerformed(event);
            } else if (object == CaiWave.this.button_stop) {
                CaiWave.this.buttonStop_ActionPerformed(event);
            } else if (object == CaiWave.this.button_reset) {
                CaiWave.this.buttonReset_ActionPerformed(event);
            }
        }

        SymAction() {
            CaiWave.this = CaiWave.this;
        }
    }

    class SymItem
    implements ItemListener {
        public void itemStateChanged(ItemEvent event) {
            Object object = event.getSource();
            if (object == CaiWave.this.radioButton_continuous) {
                CaiWave.this.radioButtonContinuous_ItemStateChanged(event);
            } else if (object == CaiWave.this.radioButton_crest) {
                CaiWave.this.radioButtonCrest_ItemStateChanged(event);
            } else if (object == CaiWave.this.radioButton_trough) {
                CaiWave.this.radioButtonTrough_ItemStateChanged(event);
            } else if (object == CaiWave.this.radioButton_free) {
                CaiWave.this.radioButtonFree_ItemStateChanged(event);
            } else if (object == CaiWave.this.radioButton_fixed) {
                CaiWave.this.radioButtonFixed_ItemStateChanged(event);
            } else if (object == CaiWave.this.radioButton_less) {
                CaiWave.this.radioButtonLess_ItemStateChanged(event);
            }
        }

        SymItem() {
            CaiWave.this = CaiWave.this;
        }
    }
}

